/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License (the "License").
 * You may not use this file except in compliance with the License.
 *
 * You can obtain a copy of the license at src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */
/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2005 Unicode, Inc. All rights reserved. Distributed
 * under the Terms of Use in http://www.unicode.org/copyright.html.
 *
 * This file has been modified by Sun Microsystems, Inc.
 */
/*
 * Copyright (c) 1994, 1995 by Sun Microsystems, Inc.
 * Copyright (c) 1994, Nihon Sun Microsystems K.K.
 * All Rights Reserved.
 */

/*
  Converts ASCII ISO 8859-1 to EBCDIC IBM-850.
  By Greg Nakhimovsky, Sun Microsystems.
  April, 1996.
*/
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <ctype.h>

#define MAGIC_NUMBER	(0x216513)
#define ERR_RETURN      (-1)            /* result code on error */

#define GET(c)          ((c) = *ip, ip++, ileft--)
#define PUT(c)          (*op = (c), op++, oleft--)
#define UNGET()         (ip--, ileft++)


/*
 * Open; called from iconv_open()
 */
void *
_icv_open()
{
	return ((void*)MAGIC_NUMBER);
}


/*
 * Close; called from iconv_close
 */
void
_icv_close(int* cd)
{
	if (!cd || cd != (int*)MAGIC_NUMBER)
		errno = EBADF;
}


/*
 * Actual conversion; called from iconv()
 */
size_t
_icv_iconv(int* cd, char **inbuf, size_t *inbytesleft,
				char **outbuf, size_t *outbytesleft)
{
	unsigned char	*ip, ic, *op;
	size_t			ileft, oleft;
	size_t			retval = 0;

	static unsigned char map[256] = {
0x00 , 0x01 , 0x02 , 0x03 , 0x04 , 0x05 , 0x06 , 0x07 , 0x08 , 0x09 ,
0x0A , 0x0B , 0x0C , 0x0D , 0x0E , 0x0F , 0x10 , 0x11 , 0x12 , 0x13 ,
0x14 , 0x15 , 0x16 , 0x17 , 0x18 , 0x19 , 0x7F , 0x1B , 0x1A , 0x1D ,
0x1E , 0x1F , 0x20 , 0x21 , 0x22 , 0x23 , 0x24 , 0x25 , 0x26 , 0x27 ,
0x28 , 0x29 , 0x2A , 0x2B , 0x2C , 0x2D , 0x2E , 0x2F , 0x30 , 0x31 ,
0x32 , 0x33 , 0x34 , 0x35 , 0x36 , 0x37 , 0x38 , 0x39 , 0x3A , 0x3B ,
0x3C , 0x3D , 0x3E , 0x3F , 0x40 , 0x41 , 0x42 , 0x43 , 0x44 , 0x45 ,
0x46 , 0x47 , 0x48 , 0x49 , 0x4A , 0x4B , 0x4C , 0x4D , 0x4E , 0x4F ,
0x50 , 0x51 , 0x52 , 0x53 , 0x54 , 0x55 , 0x56 , 0x57 , 0x58 , 0x59 ,
0x5A , 0x5B , 0x5C , 0x5D , 0x5E , 0x5F , 0x60 , 0x61 , 0x62 , 0x63 ,
0x64 , 0x65 , 0x66 , 0x67 , 0x68 , 0x69 , 0x6A , 0x6B , 0x6C , 0x6D ,
0x6E , 0x6F , 0x70 , 0x71 , 0x72 , 0x73 , 0x74 , 0x75 , 0x76 , 0x77 ,
0x78 , 0x79 , 0x7A , 0x7B , 0x7C , 0x7D , 0x7E , 0x1C , 0x1A , 0x1A ,
0x1A , 0x1A , 0x1A , 0x1A , 0x1A , 0x1A , 0x1A , 0x1A , 0x1A , 0x1A ,
0x1A , 0x1A , 0x1A , 0x1A , 0x1A , 0x1A , 0x1A , 0x1A , 0x1A , 0x1A ,
0x1A , 0x1A , 0x1A , 0x1A , 0x1A , 0x1A , 0x1A , 0x1A , 0x1A , 0x1A ,
0xFF , 0xAD , 0xBD , 0x9C , 0xCF , 0xBE , 0xDD , 0xF5 , 0xF9 , 0xB8 ,
0xA6 , 0xAE , 0xAA , 0xF0 , 0xA9 , 0xEE , 0xF8 , 0xF1 , 0xFD , 0xFC ,
0xEF , 0xE6 , 0xF4 , 0xFA , 0xF7 , 0xFB , 0xA7 , 0xAF , 0xAC , 0xAB ,
0xF3 , 0xA8 , 0xB7 , 0xB5 , 0xB6 , 0xC7 , 0x8E , 0x8F , 0x92 , 0x80 ,
0xD4 , 0x90 , 0xD2 , 0xD3 , 0xDE , 0xD6 , 0xD7 , 0xD8 , 0xD1 , 0xA5 ,
0xE3 , 0xE0 , 0xE2 , 0xE5 , 0x99 , 0x9E , 0x9D , 0xEB , 0xE9 , 0xEA ,
0x9A , 0xED , 0xE8 , 0xE1 , 0x85 , 0xA0 , 0x83 , 0xC6 , 0x84 , 0x86 ,
0x91 , 0x87 , 0x8A , 0x82 , 0x88 , 0x89 , 0x8D , 0xA1 , 0x8C , 0x8B ,
0xD0 , 0xA4 , 0x95 , 0xA2 , 0x93 , 0xE4 , 0x94 , 0xF6 , 0x9B , 0x97 ,
0xA3 , 0x96 , 0x81 , 0xEC , 0xE7 , 0x98 };

	if (!cd || cd != (int*)MAGIC_NUMBER)
	{
		errno = EBADF;
		return((size_t)ERR_RETURN);
	}

	if ((inbuf == 0) || (*inbuf == 0))
		return((size_t)0);

	ip = (unsigned char*)*inbuf;
	op = (unsigned char *)*outbuf;
	ileft = *inbytesleft;
	oleft = *outbytesleft;

	/*
	 * Main loop; basically 1 loop per 1 input byte
	 */

	while (ileft > 0) {
		GET(ic);
		if (oleft < 1) {
			UNGET();
			errno = E2BIG;
			retval = ERR_RETURN;
			goto ret;
		}
		PUT(map[ic]);
		retval++;
	}

ret:
	*inbuf = (char *)ip;
	*inbytesleft = ileft;
	*outbuf = (char *)op;
	*outbytesleft = oleft;

	return (retval);
}
